'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Detailbereich_Format(Cancel As Integer, FormatCount As Integer)
    'Zhler fr Anzahl ungedruckter Rechnungen um 1 erhhen,
    If Me.gedruckt.Value = False Then UngedruckteRechnungen = 1
    
    ZeilenNummer = ZeilenNummer + 1
    If (ZeilenNummer Mod 2) = 0 Then
        Me.ForeColor = RGB(ZeilenGrau, ZeilenGrau, ZeilenGrau)
        Me.Line (0, 0)-(14450, 220), , BF      '1-zeilig
        'Me.Line (0, 0)-(14450, 440), , BF      '2-zeilig
    End If
    
    'MwSt-Splitting?
    If Me.Kasten_MwSt_Splitting.Value = True Then
        Me.MwSt_Satz.Visible = False
        Me.MwSt_Diverse.Visible = True
    Else
        Me.MwSt_Satz.Visible = True
        Me.MwSt_Diverse.Visible = False
    End If
End Sub

Private Sub Report_Activate()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    Me.ImpFusszeile.Caption = ImpressumBerichtsfuss
    UngedruckteRechnungen = 0
    ZeilenNummer = 0
    
    Me.Ueberschrift.Caption = BerichteUeberschrift
    Me.Filter = BerichteFilter

    'aktuelles Whrungsformat des Systems einstellen
    Me.Text61.Format = "Currency"
    Me.Text63.Format = "Currency"
    Me.Text64.Format = "Currency"
    Me.Summe_von_Su_Re_Netto.Format = "Currency"
    Me.Text71.Format = "Currency"
    Me.Text70.Format = "Currency"
    Me.Text81.Format = "Currency"
    Me.Text84.Format = "Currency"
    Me.Text83.Format = "Currency"
    Me.Text85.Format = "Currency"
    Me.Text88.Format = "Currency"
    Me.Text87.Format = "Currency"
End Sub

Private Sub Seitenkopf_Print(Cancel As Integer, PrintCount As Integer)
    'Variable fr den Hinweis fllen
    Me.ReUngedruckt = UngedruckteRechnungen
End Sub
